//
//  Policy.h
//  Keychain
//
//  Created by Wade Tregaskis on Fri Jan 24 2003.
//  Copyright (c) 2003 Wade Tregaskis. All rights reserved.
//

#import "NSCachedObject.h"
#import <Foundation/Foundation.h>
#import <Security/Security.h>
#import "UtilitySupport.h"


@interface Policy : NSCachedObject {
    SecPolicyRef policy;
    int error;
}

+ (Policy*)policyWithPolicyRef:(SecPolicyRef)poli;

- (Policy*)initWithPolicyRef:(SecPolicyRef)poli;

- (NSData*)objectIdentifier;
- (NSData*)data;

- (int)lastError;
- (SecPolicyRef)policyRef;
   
@end
